parcel_services.controllers.module('edit-modal',
	['xhr', `${gx.source}/libs/info_messages`,],
	() => {
		return {
			vue: true,
			name: 'gx-edit-modal',
			template: '#edit-modal',
			parent: 'gx-parcel-services-overview',
			props: ['languages'],
			data: () => ({
				lang: {
					title: jse.core.lang.translate('edit_modal_title', 'parcel_services'),
					close: jse.core.lang.translate('cancel', 'buttons'),
					confirm: jse.core.lang.translate('save', 'buttons'),
					labels: {
						name: jse.core.lang.translate('label_name', 'parcel_services'),
						isDefault: jse.core.lang.translate('label_set_as_default', 'parcel_services'),
						comment: jse.core.lang.translate('label_comment', 'parcel_services'),
						url: jse.core.lang.translate('label_url', 'parcel_services'),
						placeholder: jse.core.lang.translate('label_tracking_number_placeholder', 'parcel_services'),
					},
				},
				validFormData: {
					name: true,
				},
				selectedLanguage: '',
				details: {
					name: '',
					isDefault: false,
					descriptions: [],
				}
			}),
			methods: {
				confirm() {
					if (this.checkFormData() === false) {
						return;
					}
					
					jse.libs.xhr.put({
						url: './api/parcel-services',
						data: this.details
					}).done(response => {
						this.$emit('reload-overview');
					}).fail((response) => {
						console.error('Could not update parcel service.', response);
						jse.libs.info_messages.addError(jse.core.lang.translate('error_could_not_update_parcel_service', 'parcel_services'));
					});
					$('.edit-modal.modal').modal('hide');
				},
				checkFormData() {
					this.validFormData.name = this.details.name.trim().length !== 0;
					
					return this.validFormData.name;
				},
				changeLanguage(languageId) {
					this.selectedLanguage = languageId;
					if (this.details.descriptions[languageId] === undefined) {
						this.details.descriptions[languageId] = {
							languageId: languageId,
							url: '',
							comment: '',
						};
					}
				},
				openModal(details) {
					this.selectedLanguage = this.languages[0].id;
					this.details = {
						id: details.id,
						name: details.name,
						isDefault: details.isDefault,
						descriptions: {},
					};
					for (const i in details.descriptions) {
						const languageId = details.descriptions[i].languageId;
						this.details.descriptions[languageId] = details.descriptions[i];
					}
					
					if (this.$children[0] !== undefined) {
						this.$children[0].input = this.details.isDefault;
					}
					gx.widgets.init($('.edit-modal.modal'));
					$('.edit-modal.modal').modal('show');
				},
			},
			init: done => done()
		}
	});